-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Dec 19, 2025 at 12:52 PM
-- Server version: 10.4.28-MariaDB
-- PHP Version: 8.0.28

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `pharmacy_db`
--

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `id` int(11) NOT NULL,
  `shop_id` int(11) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `shop_id`, `name`, `phone`, `email`, `address`, `created_at`) VALUES
(13, NULL, 'John Doe', NULL, NULL, NULL, '2025-11-14 10:08:26');

-- --------------------------------------------------------

--
-- Table structure for table `inventory_movements`
--

CREATE TABLE `inventory_movements` (
  `id` int(11) NOT NULL,
  `product_id` int(11) DEFAULT NULL,
  `batch_id` int(11) DEFAULT NULL,
  `change_qty` int(11) DEFAULT NULL,
  `movement_type` enum('PURCHASE','SALE','ADJUSTMENT','RETURN') NOT NULL,
  `reference_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  `shop_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

CREATE TABLE `payments` (
  `id` int(11) NOT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT NULL,
  `method` enum('CASH','CARD','M-PESA','TIGO-PESA','AIRTEL-MONEY') DEFAULT 'CASH',
  `paid_at` datetime DEFAULT current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  `shop_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `id` int(11) NOT NULL,
  `sku` varchar(50) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `generic_name` varchar(255) DEFAULT NULL,
  `unit` varchar(50) DEFAULT 'tablet',
  `category` varchar(100) DEFAULT NULL,
  `vat_percent` decimal(5,2) DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `vat` decimal(5,2) DEFAULT 0.00,
  `buying_price` decimal(10,2) DEFAULT 0.00,
  `selling_price` decimal(10,2) DEFAULT 0.00,
  `shop_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `sku`, `name`, `generic_name`, `unit`, `category`, `vat_percent`, `created_at`, `vat`, `buying_price`, `selling_price`, `shop_id`) VALUES
(2, 'PAR-555', 'Paracetamol 500mg', 'Panadol', 'tablet', 'Anti-pain', 0.00, '2025-11-14 07:23:42', 0.00, 0.00, 0.00, 1),
(3, 'PAR-803', 'Paracetamol 500mg', 'Panadol', 'tablets', 'Anti-pain', 0.00, '2025-12-01 11:30:44', 0.00, 0.00, 0.00, 1),
(4, 'PAR-110', 'Paracetamol 500mg', 'Panadol', 'tablet', 'Anti-pain', 3.00, '2025-12-01 11:39:19', 0.00, 120.00, 250.00, 1),
(5, 'DIC-125', 'Diclo', 'Diclofenac', 'tablet', 'Anti-pain', 2.00, '2025-12-01 12:17:52', 0.00, 300.00, 400.00, 1),
(6, 'ENO-353', 'ENO', 'CAOH', 'tablet', 'Antibiotic', 0.00, '2025-12-09 09:14:26', 0.00, 200.00, 300.00, 1),
(7, 'REL-329', 'RELCER GEL', 'ALOH', 'SYRUP', 'ANT ACID', 0.00, '2025-12-09 10:15:21', 0.00, 1200.00, 200.00, 1);

-- --------------------------------------------------------

--
-- Table structure for table `product_batches`
--

CREATE TABLE `product_batches` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `batch_no` varchar(100) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 0,
  `cost_price` decimal(12,2) NOT NULL,
  `sell_price` decimal(12,2) NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(250) NOT NULL,
  `updated_at` datetime NOT NULL DEFAULT current_timestamp(),
  `shop_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `product_batches`
--

INSERT INTO `product_batches` (`id`, `product_id`, `batch_no`, `qty`, `cost_price`, `sell_price`, `expiry_date`, `supplier_id`, `created_by`, `created_at`, `updated_by`, `updated_at`, `shop_id`, `is_active`) VALUES
(4, 2, '265656', 0, 300.00, 400.00, '2025-11-30', 1, 1, '2025-11-14 07:27:37', '1', '2025-12-02 14:59:52', 1, 0),
(5, 2, '265656', 7999324, 500.00, 1200.00, '2025-11-30', 1, 1, '2025-11-14 07:30:23', '1', '2025-12-02 15:03:01', 1, 0),
(6, 4, '577887', 150, 300.00, 4000.00, '2025-12-31', 2, 1, '2025-12-01 12:10:49', '', '2025-12-01 15:10:49', NULL, 1),
(8, 5, '502', 87, 300.00, 400.00, '2027-06-25', 1, 1, '2025-12-02 12:04:41', '1', '2025-12-09 09:27:13', 1, 1),
(9, 2, '265656', 12, 100.00, 500.00, '2025-12-31', 1, 1, '2025-12-03 08:05:28', '', '2025-12-03 11:05:28', NULL, 1),
(10, 5, '2312', 15, 50.00, 300.00, '2025-12-31', 1, 1, '2025-12-03 08:05:28', '', '2025-12-03 11:05:28', NULL, 1),
(11, 4, '567', 32, 120.00, 250.00, '2026-03-10', 2, 1, '2025-12-09 09:59:13', '1', '2025-12-09 10:21:36', 1, 1),
(12, 7, '345', 20, 1200.00, 200.00, '2026-02-10', 3, 1, '2025-12-09 10:24:08', 'Dr.Augustino', '2025-12-09 10:24:08', 1, 1),
(13, 2, '265656', 11, 200.00, 300.00, '2025-12-31', 3, 1, '2025-12-11 10:33:04', '1', '2025-12-11 13:33:04', 1, 1),
(14, 6, '502', 10, 200.00, 300.00, '2025-12-31', 3, 1, '2025-12-11 11:46:46', 'Patience Ndyetabla', '2025-12-11 14:46:46', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `purchases`
--

CREATE TABLE `purchases` (
  `id` int(11) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `invoice_no` varchar(100) DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `total` decimal(12,2) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `shop_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `purchases`
--

INSERT INTO `purchases` (`id`, `supplier_id`, `invoice_no`, `purchase_date`, `total`, `created_by`, `updated_by`, `created_at`, `shop_id`) VALUES
(2, 1, '566', '2025-11-14', 2036000.00, 1, NULL, '2025-11-14 07:30:23', 1),
(3, 1, '566', '2025-12-03', 1950.00, 1, NULL, '2025-12-03 08:05:28', NULL),
(4, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:18', 1),
(5, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:24', 1),
(6, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:26', 1),
(7, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:27', 1),
(8, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:29', 1),
(9, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:30', 1),
(10, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:31', 1),
(11, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:33', 1),
(12, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:34', 1),
(13, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:34', 1),
(14, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:35', 1),
(15, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:35', 1),
(16, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:38', 1),
(17, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:39', 1),
(18, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:41', 1),
(19, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:42', 1),
(20, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:43', 1),
(21, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:44', 1),
(22, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:44', 1),
(23, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:45', 1),
(24, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:47', 1),
(25, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:48', 1),
(26, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:49', 1),
(27, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:49', 1),
(28, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:51', 1),
(29, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:52', 1),
(30, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:53', 1),
(31, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:54', 1),
(32, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:55', 1),
(33, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:56', 1),
(34, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:58', 1),
(35, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:58', 1),
(36, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:16:59', 1),
(37, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:01', 1),
(38, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:02', 1),
(39, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:02', 1),
(40, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:08', 1),
(41, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:09', 1),
(42, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:10', 1),
(43, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:10', 1),
(44, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:13', 1),
(45, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:14', 1),
(46, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:15', 1),
(47, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:17', 1),
(48, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:18', 1),
(49, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:19', 1),
(50, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:19', 1),
(51, 1, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 09:17:22', 1),
(52, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:48', 1),
(53, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:52', 1),
(54, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:52', 1),
(55, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:53', 1),
(56, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:53', 1),
(57, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:54', 1),
(58, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:54', 1),
(59, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:54', 1),
(60, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:55', 1),
(61, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:55', 1),
(62, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:55', 1),
(63, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:17:56', 1),
(64, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:15', 1),
(65, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:16', 1),
(66, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:16', 1),
(67, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:16', 1),
(68, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:16', 1),
(69, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:16', 1),
(70, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:18', 1),
(71, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:19', 1),
(72, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:23', 1),
(73, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:24', 1),
(74, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:25', 1),
(75, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:25', 1),
(76, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:26', 1),
(77, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:26', 1),
(78, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:26', 1),
(79, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:26', 1),
(80, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:27', 1),
(81, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:27', 1),
(82, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:27', 1),
(83, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:27', 1),
(84, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:27', 1),
(85, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:27', 1),
(86, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:28', 1),
(87, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:29', 1),
(88, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:30', 1),
(89, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:30', 1),
(90, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:30', 1),
(91, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:30', 1),
(92, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:30', 1),
(93, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:31', 1),
(94, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:31', 1),
(95, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:31', 1),
(96, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:32', 1),
(97, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:32', 1),
(98, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:32', 1),
(99, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:32', 1),
(100, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:33', 1),
(101, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:33', 1),
(102, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:33', 1),
(103, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:33', 1),
(104, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:34', 1),
(105, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:34', 1),
(106, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:35', 1),
(107, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:35', 1),
(108, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:35', 1),
(109, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:35', 1),
(110, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:36', 1),
(111, 3, '1234', '2025-12-09', NULL, 1, NULL, '2025-12-09 10:18:36', 1),
(112, 3, '566', '2025-12-10', NULL, 1, NULL, '2025-12-10 09:18:24', 1),
(119, 3, 'INV-20251114-0012', '2025-12-11', 4000.00, 1, NULL, '2025-12-11 07:52:56', 1),
(120, 1, '566', '2025-12-11', 2400.00, 1, NULL, '2025-12-11 07:54:02', 1),
(129, 3, '566', '2025-12-11', 4500.00, 1, 1, '2025-12-11 10:33:04', 1);

-- --------------------------------------------------------

--
-- Table structure for table `purchase_lines`
--

CREATE TABLE `purchase_lines` (
  `id` int(11) NOT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `batch_id` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `cost_price` decimal(12,2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `purchase_lines`
--

INSERT INTO `purchase_lines` (`id`, `purchase_id`, `batch_id`, `qty`, `cost_price`) VALUES
(3, 2, 4, 5000, 400.00),
(4, 2, 8, 150, 200.00),
(5, 3, 9, 12, 100.00),
(6, 3, 10, 15, 50.00),
(7, 2, 4, 20, 300.00),
(8, 129, 13, 15, 300.00);

-- --------------------------------------------------------

--
-- Table structure for table `sales`
--

CREATE TABLE `sales` (
  `id` int(11) NOT NULL,
  `invoice_no` varchar(100) DEFAULT NULL,
  `sale_date` datetime DEFAULT current_timestamp(),
  `customer_id` int(11) DEFAULT NULL,
  `total` decimal(12,2) DEFAULT NULL,
  `paid` decimal(12,2) DEFAULT 0.00,
  `status` enum('open','paid','partially_paid','cancelled') DEFAULT 'open',
  `created_by` int(11) DEFAULT NULL,
  `shop_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `sales`
--

INSERT INTO `sales` (`id`, `invoice_no`, `sale_date`, `customer_id`, `total`, `paid`, `status`, `created_by`, `shop_id`) VALUES
(2, 'INV-20251114-002', '2025-11-14 16:10:11', NULL, 16800.00, 13200.00, 'open', 1, 1),
(3, 'INV-20251114-003', '2025-11-14 16:11:17', NULL, 12000.00, 120000.00, 'open', 1, 1),
(5, 'INV-20251204-001', '2025-12-04 11:23:23', NULL, 6400.00, 6400.00, 'open', 1, 1),
(6, 'INV-20251204-002', '2025-12-04 11:24:44', NULL, 1200.00, 1200.00, 'open', 1, 1),
(7, 'INV-20251205-001', '2025-12-05 09:54:58', NULL, 12000.00, 12000.00, 'open', 1, 1),
(8, 'INV-20251209-001', '2025-12-09 09:10:13', NULL, 155999.00, 0.00, 'open', 1, 1),
(9, 'INV-20251209-002', '2025-12-09 09:34:27', NULL, 359980.00, 0.00, 'open', 1, 1),
(10, 'INV-20251209-003', '2025-12-09 09:47:30', NULL, 6000.00, 0.00, 'open', 1, 1),
(11, 'INV-20251209-004', '2025-12-09 09:48:07', NULL, 6000.00, 0.00, 'open', 1, 1),
(12, 'INV-20251216-001', '2025-12-16 10:13:34', NULL, 4500.00, 4500.00, 'open', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sale_lines`
--

CREATE TABLE `sale_lines` (
  `id` int(11) NOT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `batch_id` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `unit_price` decimal(12,2) DEFAULT NULL,
  `discount` decimal(12,2) DEFAULT 0.00,
  `line_total` decimal(12,2) DEFAULT NULL,
  `shop_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `sale_lines`
--

INSERT INTO `sale_lines` (`id`, `sale_id`, `product_id`, `batch_id`, `qty`, `unit_price`, `discount`, `line_total`, `shop_id`) VALUES
(2, 2, 2, 5, 14, 1200.00, 0.00, 16800.00, 1),
(3, 3, 2, 5, 10, 1200.00, 0.00, 12000.00, 1),
(5, 5, 2, 5, 1, 1200.00, 0.00, 1200.00, NULL),
(6, 5, 5, 8, 13, 400.00, 0.00, 5200.00, NULL),
(7, 6, 2, 5, 1, 1200.00, 0.00, 1200.00, NULL),
(8, 7, 2, 5, 10, 1200.00, 0.00, 12000.00, NULL),
(9, 8, 2, 5, 100, 1200.00, 0.00, 120000.00, NULL),
(10, 8, 2, 5, 30, 1200.00, 1.00, 35999.00, NULL),
(11, 9, 2, 5, 300, 1200.00, 20.00, 359980.00, NULL),
(12, 10, 2, 5, 5, 1200.00, 0.00, 6000.00, NULL),
(13, 11, 2, 5, 5, 1200.00, 0.00, 6000.00, NULL),
(14, 12, 4, 11, 18, 250.00, 0.00, 4500.00, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `shops`
--

CREATE TABLE `shops` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `address` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `shops`
--

INSERT INTO `shops` (`id`, `name`, `phone`, `address`, `created_at`) VALUES
(1, 'Goodhope Consultation Pharmacy', '', 'Kamachumu', '2025-12-01 09:02:46'),
(2, 'Shop A', '', 'Bukoba', '2025-12-01 09:10:06'),
(3, 'Shop B', '', 'Mwanza', '2025-12-01 09:10:06');

-- --------------------------------------------------------

--
-- Table structure for table `suppliers`
--

CREATE TABLE `suppliers` (
  `id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `contact` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `suppliers`
--

INSERT INTO `suppliers` (`id`, `name`, `contact`, `email`, `address`, `created_at`) VALUES
(1, 'BARICK', '074234522', 'dd@gg.com', 'Bukoba', '2025-11-11 10:55:52'),
(2, 'SHEKAINA WORLD PHARMACY', '0716011831', 'shekaina@gmail.com', 'Shekaina Bukoba\r\nP.O.Box 35091 Bukoba', '2025-11-21 10:37:00'),
(3, 'MARAK PHARMACY', '0767795050', 'agustino0511@icloud.com', 'p.o.box 10 K/KKO', '2025-12-09 10:12:35');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `fullname` varchar(150) DEFAULT NULL,
  `role` enum('admin','pharmacist','cashier') NOT NULL DEFAULT 'cashier',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `shop_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `password_hash`, `fullname`, `role`, `created_at`, `shop_id`) VALUES
(1, 'admin', '$2y$10$.GPFn6tIdCa0fqzOBUUoi.irH5T2ZnPc69rCwfyHnjR6E06QGXX5a', 'Dr.Augustino', 'admin', '2025-11-11 07:14:00', 1),
(2, 'myuser', 'mypass', 'Some Name', 'admin', '2025-12-19 11:31:28', 1),
(3, 'root', '123', 'Some Random Name', 'admin', '2025-12-19 11:45:00', 1);

--
-- Indexes for dumped tables
--

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `inventory_movements`
--
ALTER TABLE `inventory_movements`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `payments`
--
ALTER TABLE `payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sale_id` (`sale_id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `sku` (`sku`),
  ADD KEY `shop_id` (`shop_id`);

--
-- Indexes for table `product_batches`
--
ALTER TABLE `product_batches`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `supplier_id` (`supplier_id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `purchases`
--
ALTER TABLE `purchases`
  ADD PRIMARY KEY (`id`),
  ADD KEY `supplier_id` (`supplier_id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `purchase_lines`
--
ALTER TABLE `purchase_lines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `purchase_id` (`purchase_id`),
  ADD KEY `batch_id` (`batch_id`);

--
-- Indexes for table `sales`
--
ALTER TABLE `sales`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `invoice_no` (`invoice_no`),
  ADD KEY `customer_id` (`customer_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `fk_sales_shop` (`shop_id`);

--
-- Indexes for table `sale_lines`
--
ALTER TABLE `sale_lines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sale_id` (`sale_id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `batch_id` (`batch_id`);

--
-- Indexes for table `shops`
--
ALTER TABLE `shops`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `suppliers`
--
ALTER TABLE `suppliers`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `inventory_movements`
--
ALTER TABLE `inventory_movements`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payments`
--
ALTER TABLE `payments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `product_batches`
--
ALTER TABLE `product_batches`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `purchases`
--
ALTER TABLE `purchases`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=130;

--
-- AUTO_INCREMENT for table `purchase_lines`
--
ALTER TABLE `purchase_lines`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `sales`
--
ALTER TABLE `sales`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `sale_lines`
--
ALTER TABLE `sale_lines`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `shops`
--
ALTER TABLE `shops`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `suppliers`
--
ALTER TABLE `suppliers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `payments`
--
ALTER TABLE `payments`
  ADD CONSTRAINT `payments_ibfk_1` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`),
  ADD CONSTRAINT `payments_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`);

--
-- Constraints for table `products`
--
ALTER TABLE `products`
  ADD CONSTRAINT `fk_products_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`);

--
-- Constraints for table `product_batches`
--
ALTER TABLE `product_batches`
  ADD CONSTRAINT `product_batches_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  ADD CONSTRAINT `product_batches_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`),
  ADD CONSTRAINT `product_batches_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`);

--
-- Constraints for table `purchases`
--
ALTER TABLE `purchases`
  ADD CONSTRAINT `purchases_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`),
  ADD CONSTRAINT `purchases_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`);

--
-- Constraints for table `purchase_lines`
--
ALTER TABLE `purchase_lines`
  ADD CONSTRAINT `purchase_lines_ibfk_1` FOREIGN KEY (`purchase_id`) REFERENCES `purchases` (`id`),
  ADD CONSTRAINT `purchase_lines_ibfk_2` FOREIGN KEY (`batch_id`) REFERENCES `product_batches` (`id`);

--
-- Constraints for table `sales`
--
ALTER TABLE `sales`
  ADD CONSTRAINT `fk_sales_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`),
  ADD CONSTRAINT `sales_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`),
  ADD CONSTRAINT `sales_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`);

--
-- Constraints for table `sale_lines`
--
ALTER TABLE `sale_lines`
  ADD CONSTRAINT `sale_lines_ibfk_1` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`),
  ADD CONSTRAINT `sale_lines_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  ADD CONSTRAINT `sale_lines_ibfk_3` FOREIGN KEY (`batch_id`) REFERENCES `product_batches` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
